package gov.va.med.mhv.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "USER_EMAIL_ADDRESS_HISTORY")
public class UserEmailAddressHistory extends AbstractBaseEntity {

	private static final long serialVersionUID = -5019461482081888144L;
	
	@Id
	@Column(name = "USER_EMAIL_ADDRESS_HISTORY_ID")
	@SequenceGenerator(name = "id_sequence", sequenceName = "USER_EMAIL_ADDR_HST_SEQ", allocationSize=1)
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="id_sequence")
	private Long id;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;

	@Column(name = "EMAIL_ADDRESS")
	private String emailAddress;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "CHANGED_BY")
	private String changedBy;
	
	@Column(name = "REASON")
	private String reason;

	public UserEmailAddressHistory() {
		
	}

	public Long getId() {
		return id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	public String getEmailAddress() {
		return emailAddress;
	}
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getChangedBy() {
		return changedBy;
	}
	public void setChangedBy(String changedBy) {
		this.changedBy = changedBy;
	}

	public String getReason() {
		return reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}
}
